var sock;
var youtube = true;
var netflix = true;
var wikipedia = true;
var instagram = true;
var twitch = true;
var dailymotion = true;
var twitter = true;
var disneyplus = true;
var hulu = true;

function openSocket() {
	sock = new WebSocket("ws://localhost:3550/");
	
	sock.onclose = function(e) {
		sock = undefined;
	}
}

localforage.setDriver(localforage.INDEXEDDB);

localforage.getItem("youtube_logrpc").then(function(enabled) {
    if (enabled != null) {
        if (enabled == 'y') {
            youtube = true;
        } else {
            youtube = false;
        }
    }
});
localforage.getItem("netflix_logrpc").then(function(enabled) {
    if (enabled != null) {
        if (enabled == 'y') {
            netflix = true;
        } else {
            netflix = false;
        }
    }
});
localforage.getItem("wikipedia_logrpc").then(function(enabled) {
    if (enabled != null) {
        if (enabled == 'y') {
            wikipedia = true;
        } else {
            wikipedia = false;
        }
    }
});
localforage.getItem("instagram_logrpc").then(function(enabled) {
    if (enabled != null) {
        if (enabled == 'y') {
            instagram = true;
        } else {
            instagram = false;
        }
    }
});
localforage.getItem("twitch_logrpc").then(function(enabled) {
    if (enabled != null) {
        if (enabled == 'y') {
            twitch = true;
        } else {
            twitch = false;
        }
    }
});
localforage.getItem("dailymotion_logrpc").then(function(enabled) {
    if (enabled != null) {
        if (enabled == 'y') {
            dailymotion = true;
        } else {
            dailymotion = false;
        }
    }
});
localforage.getItem("twitter_logrpc").then(function(enabled) {
    if (enabled != null) {
        if (enabled == 'y') {
            twitter = true;
        } else {
            twitter = false;
        }
    }
});
localforage.getItem("disneyplus_logrpc").then(function(enabled) {
    if (enabled != null) {
        if (enabled == 'y') {
            disneyplus = true;
        } else {
            disneyplus = false;
        }
    }
});
localforage.getItem("hulu_logrpc").then(function(enabled) {
    if (enabled != null) {
        if (enabled == 'y') {
            hulu = true;
        } else {
            hulu = false;
        }
    }
});

function updatePresence(tab, document) {
    if (tab) {
        var url = new URL(tab.url);
        var data = {
            action: "set",
            url: tab.url,
            details: url.hostname,
            state: tab.title,
            smallText: tab.url,
            largeText: tab.title,
            html: document,
            youtube: youtube,
            netflix: netflix,
            wikipedia: wikipedia,
            instagram: instagram,
            twitch: twitch,
            dailymotion: dailymotion,
            twitter: twitter,
	    disneyplus: disneyplus,
            hulu: hulu,
        };
    } else {
        var data = {
            action: "clear"
        };
    }

    sock.send(JSON.stringify(data));
}

chrome.runtime.onMessage.addListener(function(msg, sender) {
  if (msg.html != null) {
    chrome.tabs.query({active: true, currentWindow: true}, function (tab) {
	  updatePresence(tab[0], msg.html);
    });
  } else {
   if (msg.youtube_logrpc == 'y') {
                 youtube = true;
             } else {
                 youtube = false;
             }
             if (msg.netflix_logrpc == 'y') {
                 netflix = true;
             } else {
                 netflix = false;
             }
             if (msg.wikipedia_logrpc == 'y') {
                 wikipedia = true;
             } else {
                 wikipedia = false;
             }
             if (msg.instagram_logrpc == 'y') {
                 instagram = true;
             } else {
                 instagram = false;
             }
             if (msg.twitch_logrpc == 'y') {
                 twitch = true;
             } else {
                 twitch = false;
             }
             if (msg.dailymotion_logrpc == 'y') {
                 dailymotion = true;
             } else {
                 dailymotion = false;
             }
             if (msg.twitter_logrpc == 'y') {
                 twitter = true;
             } else {
                 twitter = false;
             }
     		if (msg.disneyplus_logrpc == 'y') {
                 disneyplus = true;
             } else {
                 disneyplus = false;
             }
			if (msg.hulu_logrpc == 'y') {
                 hulu = true;
             } else {
                 hulu = false;
             }
  }
});

chrome.tabs.onActivated.addListener(function (tabId) {
    chrome.tabs.executeScript({
        code: "document.body.innerHTML"
    }, function(result) {
        if (chrome.runtime.lastError) {
            console.error(chrome.runtime.lastError.message);
        } else {
            chrome.tabs.query({active: true, currentWindow: true}, function (tab) {
				updatePresence(tab[0], result[0]);
			});
        }
    });
});

chrome.tabs.onUpdated.addListener(function (tabId) {
    chrome.tabs.executeScript({
        code: "document.body.innerHTML"
    }, function(result) {
        if (chrome.runtime.lastError) {
            console.error(chrome.runtime.lastError.message);
        } else {
            chrome.tabs.query({active: true, currentWindow: true}, function (tab) {
				updatePresence(tab[0], result[0]);
			});
        }
    });
});

chrome.windows.onFocusChanged.addListener(function (windowId) {
	chrome.tabs.executeScript({
        code: "document.body.innerHTML"
    }, function(result) {
        if (chrome.runtime.lastError) {
            console.error(chrome.runtime.lastError.message);
        } else {
            chrome.tabs.query({active: true, currentWindow: true}, function (tab) {
				updatePresence(tab[0], result[0]);
			});
        }
    });
});

chrome.webNavigation.onCompleted.addListener(function(details) {
    chrome.tabs.executeScript({
        code: "document.body.innerHTML"
    }, function(result) {
        if (chrome.runtime.lastError) {
            console.error(chrome.runtime.lastError.message);
        } else {
            chrome.tabs.query({active: true, currentWindow: true}, function (tab) {
				updatePresence(tab[0], result[0]);
			});
        }
    });
});

setInterval(function() {
	if (sock == undefined) {
		openSocket();
	}
}, 1000);